/* main.cpp : Defines the entry point for the application.

   This file is part of the "PE Maker".

   Copyright (C) 2005-2006 Ashkbiz Danehkar
   All Rights Reserved.

   "PE Maker" library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYRIGHT.TXT.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   yodap's Forum:
   http://yodapforum.has.it/

   yodap's Site:
   http://yodap.has.it
   http://yodap.cjb.net
   http://yodap.sourceforge.net

   Ashkbiz Danehkar
   <ashkbiz@yahoo.com>
*/

//#define  WIN32_LEAN_AND_MEAN
#include "stdafx.h"
#include "main.h"
#include "About.h"
#include <winnt.h>
//--------------------------------------------
#pragma comment(linker,"/BASE:0x400000 /FILEALIGN:0x200 /MERGE:.rdata=.text /MERGE:.data=.text /SECTION:.text,EWR /IGNORE:4078")
#pragma pack(1)
//--------------------------------------------
#ifdef AP_UNIX_STYLE
   #include <unistd.h>
   #define CB_CALLCONV
#else
   #include <io.h>
   #define AP_HAS_CONIO
   #ifdef AP_DLL
      #define CB_CALLCONV __stdcall
   #else
      #define CB_CALLCONV __cdecl
   #endif
#endif
//---------------------------------------------
class CMainForm
{
private:
	//-----------------------------------------
	HDROP	hDrop;
	HICON	hIcon;
	HBITMAP	hBitmap;
	HWND	hButton;
	HMENU	hSysMenu;
	HACCEL	hAccel;
	//-----------------------------------------
	DWORD nFilterIndex;
	BOOL bFileOpen;
	//-----------------------------------------
	char cFname[255];
	char *cFnameOpen;
	char *cFnameSave;
	//-----------------------------------------
	OPENFILENAME openfn;
	OPENFILENAME savefn;
	//-----------------------------------------
public:
	//-----------------------------------------
	HWND	hwndMain;// main application window 
	//-----------------------------------------
	BOOL OnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam);
	void OnCommand (HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
	void OnSysCommand(HWND hwnd, UINT cmd, int x, int y);
	void OnDropFiles(HWND hwnd, HDROP hDrop);
	void OnPaint (HWND hwnd);
	void OnDestroy (HWND hwnd);
	void OnClose(HWND hwnd);
public:
	//-----------------------------------------
	CMainForm();
	~CMainForm();
	//-----------------------------------------
};
//--------------------------------------------
CMainForm *MainForm;
//--------------------------------------------
// Global Variables:
//--------------------------------------------
HINSTANCE hInst;	// current instance

//--------------------------------------------
static char szCurDir[]=".";
static char szFilterOpn[]=TEXT("Executable files (*.exe)\0*.exe\0Dynamic Link Libraries (*.dll)\0*.dll\0OLE-ActiveX Controls (*.ocx)\0*.ocx\0Screen Savers (*.scr)\0*.scr\0All files (*.*)\0*.*\0\0");
static char* szAbout = "About...";
//--------------------------------------------
static CPECryptor	*PEfile;
//--------------------------------------------
// Forward declarations of functions included in this code module:
//--------------------------------------------
static void EnableItems(HWND hwnd);
static int CB_CALLCONV callback(unsigned int inpos, unsigned int outpos);
//--------------------------------------------
static LRESULT DlgProc(HWND hDlg,UINT uiMsg,WPARAM wParam,LPARAM lParam);
//--------------------------------------------

/****************************************************************************
*								WinMain
****************************************************************************/
int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	MainForm=new(CMainForm);
	MSG msg;
	hInst=GetModuleHandle(0);
	DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_MAINDLG),0,(DLGPROC)DlgProc,0);
	delete MainForm;
	ExitProcess(0);
	return (int) msg.wParam;
}
//***************************************************************************
CMainForm ::CMainForm()
{
	nFilterIndex=1;
	bFileOpen=FALSE;
	cFnameOpen = new CHAR[255];
	cFnameSave = new CHAR[255];
}
//***************************************************************************
CMainForm ::~CMainForm()
{
	delete [] cFnameOpen;
	delete [] cFnameSave;
}
/****************************************************************************
*						DlgProc(HWND, unsigned, WORD, LONG)
*
*  PURPOSE:  Processes messages for the main window.
*
*  WM_INITDIALOG	- initialize the application
*  WM_COMMAND		- process the application
*  WM_SYSCOMMAND	- process the system menu
*  WM_PAINT			- Paint the main window
*  WM_DESTROY		- post a quit message and return
*  WM_CLOSE			- process close event
*  WM_DROPFILES		- for drop file into the application
*
****************************************************************************/
static LRESULT DlgProc(HWND hDlg,UINT uiMsg,WPARAM wParam,LPARAM lParam)
{
	switch (uiMsg) 
	{
	HANDLE_MSG(hDlg, WM_INITDIALOG,	MainForm->OnInitDialog);
	HANDLE_MSG(hDlg, WM_COMMAND,	MainForm->OnCommand);
	HANDLE_MSG(hDlg, WM_SYSCOMMAND,	MainForm->OnSysCommand);
	HANDLE_MSG(hDlg, WM_PAINT,		MainForm->OnPaint);
	HANDLE_MSG(hDlg, WM_DESTROY,	MainForm->OnDestroy);
	HANDLE_MSG(hDlg, WM_CLOSE,		MainForm->OnClose);
	HANDLE_MSG(hDlg, WM_DROPFILES,	MainForm->OnDropFiles);
	}
	return 0;
}
/****************************************************************************
*								OnInitDialog
****************************************************************************/
BOOL CMainForm::OnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
	hwndMain=hwnd;
	hIcon=LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON));
	SendMessage(hwnd,WM_SETICON,TRUE,(WPARAM)hIcon);
	hAccel=LoadAccelerators(hInst,MAKEINTRESOURCE(IDC_PEMAKER));
	DragAcceptFiles(hwnd,TRUE);
	hSysMenu = GetSystemMenu(hwnd,FALSE);
	if (hSysMenu != NULL)
	{
		AppendMenu(hSysMenu,MF_SEPARATOR,0,0);
		AppendMenu(hSysMenu,MF_STRING | MF_ENABLED,
				ID_ABOUT,szAbout);
	}
	PEfile=new (CPECryptor);
	return FALSE;
}
/****************************************************************************
*								OnCommand
*
*  hwnd			Handle of window to which this message applies
*  id			Specifies the identifier of the menu item, 
*				control, or accelerator.
*  hwndCtl		Handle of the control sending the message if the message
*				is from a control, otherwise, this parameter is NULL. 
*  codeNotify	Specifies the notification code if the message is from 
*				a control.
*				This parameter is 1 when the message is from an 
*				accelerator.
*				This parameter is 0 when the message is from a menu.
****************************************************************************/
void CMainForm::OnCommand (HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
	switch (id) 
	{	/* id */
		case IDCLOSE:
			SendMessage(hwnd,WM_CLOSE,NULL,NULL);
			break;
              	                  
		case IDOK:
			EndDialog(hwnd,0);
			break;

		case ID_ABOUT:
			DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hwnd, (DLGPROC)About);
			break;     

		case ID_FILE_OPEN:
			// get a file path
 			cFname[0]=0x00;
			ZeroMemory(&openfn, sizeof(openfn));
			openfn.hwndOwner=GetActiveWindow();
			openfn.lpstrFile=cFname;
			openfn.nMaxFile=sizeof(cFname);
			openfn.lStructSize=sizeof(openfn);
			openfn.lpstrFilter=szFilterOpn; 
			openfn.nFilterIndex=nFilterIndex;
			//openfn.lpstrInitialDir=szCurDir;
			openfn.Flags=OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_LONGNAMES | OFN_HIDEREADONLY;
			if(!GetOpenFileName(&openfn))
			{
				return;
			}
			strcpy(cFnameOpen,cFname);
			strcpy(cFnameSave,cFnameOpen);
			SetDlgItemText(hwnd,IDC_FILE_OPEN,cFnameOpen);
			SetDlgItemText(hwnd,IDC_FILE_SAVE,cFnameSave);
			EnableItems(hwnd);
			if(cFnameOpen[0]==0x00) return;
			PEfile->OpenFile(cFnameOpen);
			bFileOpen=TRUE;
			break;

		case ID_FILE_SAVE:
			// get a file path
			if (!bFileOpen) return;
			cFnameSave[0]=0x00;
			strcpy(cFnameSave,cFnameOpen);
			ZeroMemory(&savefn, sizeof(savefn));
			savefn.hwndOwner=GetActiveWindow();
			savefn.lpstrFile=cFnameSave;
			savefn.nMaxFile=sizeof(cFnameSave);
			savefn.lStructSize=sizeof(savefn);
			savefn.lpstrFilter=szFilterOpn;
			savefn.nFilterIndex = openfn.nFilterIndex; 
			//savefn.lpstrInitialDir=szCurDir;
			savefn.Flags=OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_LONGNAMES | OFN_HIDEREADONLY;
			if(!GetSaveFileName(&savefn))
			{
				return;
			}
			SetDlgItemText(hwnd,IDC_FILE_SAVE,cFnameSave);
			break;

		case ID_FILE_PROTECT:
			SendDlgItemMessage(hwnd,IDC_PROGRESS1,PBM_SETSTEP,1,0);
			SendDlgItemMessage(hwnd,IDC_PROGRESS1,PBM_SETPOS,0,0);
			PEfile->CryptFile(callback);
			PEfile->SaveFile(cFnameSave);
			break;

	}/* id */
}

/****************************************************************************
*								OnSysCommand
****************************************************************************/
void CMainForm::OnSysCommand(HWND hwnd,UINT cmd, int x, int y)
{
	switch (cmd) 
	{	/* id */
		case ID_ABOUT:
			DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hwnd, (DLGPROC)About);
			break;     
	}/* id */
}

/****************************************************************************
*								OnPaint
*
*  hwnd            Handle of window to which this message applies
*
*  hdrop           Handle of drop
*
****************************************************************************/
void CMainForm::OnDropFiles(HWND hwnd, HDROP hDrop)
{
	DragQueryFile(hDrop,0,cFname,sizeof(cFname));
	DragFinish(hDrop);
	strcpy(cFnameOpen,cFname);
	SetDlgItemText(hwnd,IDC_FILE_OPEN,cFnameOpen);
	EnableItems(hwnd);
	if(cFnameOpen[0]==0x00) return;
	PEfile->OpenFile(cFnameOpen);
	bFileOpen=TRUE;
	strcpy(cFnameSave,cFnameOpen);
	SetDlgItemText(hwnd,IDC_FILE_OPEN,cFnameOpen);
	SetDlgItemText(hwnd,IDC_FILE_SAVE,cFnameSave);
}

/****************************************************************************
*								OnPaint
*
*  hwnd            Handle of window to which this message applies
*
*  PURPOSE:        Windows calls this handler when the window needs 
*			       repainting.
****************************************************************************/
void CMainForm::OnPaint (HWND hwnd)
{
    HDC         hdc ;
    PAINTSTRUCT ps ;

	hdc = BeginPaint(hwnd, &ps);
	// TODO: Add any drawing code here...
	EndPaint(hwnd, &ps);
}

/****************************************************************************
*								OnDestroy
*
*  hwnd            Handle of window to which this message applies
*
*  PURPOSE:        Notification that the specified window is being destroyed.
*                  The window is no longer visible to the user.
****************************************************************************/
void CMainForm::OnDestroy (HWND hwnd)
{
	delete PEfile;
	PostQuitMessage(0);;
}

/****************************************************************************
*								OnClose
*
*  hwnd            Handle of window to which this message applies
*
*  PURPOSE:        Notification that the specified window is being closed.
*
****************************************************************************/
void CMainForm::OnClose(HWND hwnd)
{
	EndDialog(hwnd,0);
}
//***************************************************************************
static void EnableItems(HWND hwnd)
{
	HWND hButton;
	hButton=GetDlgItem(hwnd,ID_FILE_SAVE); 
	EnableWindow(hButton,TRUE);
	hButton=GetDlgItem(hwnd,IDC_FILE_SAVE); 
	EnableWindow(hButton,TRUE);
	hButton=GetDlgItem(hwnd,IDC_STATIC_SAVE); 
	EnableWindow(hButton,TRUE);
	hButton=GetDlgItem(hwnd,ID_FILE_PROTECT); 
	EnableWindow(hButton,TRUE);
}
//***************************************************************************
static int CB_CALLCONV callback(unsigned int inpos, unsigned int outpos)
{
   SendDlgItemMessage(MainForm->hwndMain,IDC_PROGRESS1,PBM_SETPOS,inpos,0);
   return (1); // continue packing
}
