#include <windows.h>
#include <stdio.h>
#include <tchar.h>
#include <conio.h>

#define RESOURCES_MAGIC_NUMBER			0xBEEFCACE

class CResourcesFile
{

public:

	CResourcesFile();
	~CResourcesFile();

	BYTE *pBaseAddress;
	UINT Size;

	DWORD Version;
	DWORD NumberOfResources;
	DWORD NumberOfTypes;

	BYTE *pTypes;
	BYTE *pNamesOffsets;
	BYTE *pDataSection;
	BYTE *pNames;

	BOOL ProcessResourcesFile(BYTE *pAddress, UINT uSize);
	BOOL ReadName(UINT nResource, WCHAR *Str, UINT Len);
	BOOL GetResourceInfo(UINT nResource, WCHAR *Str, UINT Len,
		DWORD *Offset, INT *TypeIndex);

private:

	BOOL DecodeInt(BYTE *pAddress, INT *Value, UINT *uSize);
};

CResourcesFile::CResourcesFile()
{
}

CResourcesFile::~CResourcesFile()
{
}

BOOL CResourcesFile::ProcessResourcesFile(BYTE *pAddress, UINT uSize)
{
	BYTE *ptr = pAddress;

	//
	// Collect basic information: pointer and size of the file
	//

	pBaseAddress = ptr;
	Size = uSize;

	//
	// Read the magic number, its value has to be: 0xBEEFCACE
	//

	DWORD MagicNumber;

	MagicNumber = *(DWORD *) ptr;
	ptr += sizeof (DWORD);

	if (MagicNumber != RESOURCES_MAGIC_NUMBER)
		return FALSE;

	DWORD NumberOfReaderTypes;

	NumberOfReaderTypes = *(DWORD *) ptr;
	ptr += sizeof (DWORD);

	DWORD SizeOfReaderTypes;

	SizeOfReaderTypes = *(DWORD *) ptr;
	ptr += sizeof (DWORD);

	//
	// Skip ReaderTypes
	//

	ptr += SizeOfReaderTypes;

	//

	Version = *(DWORD *) ptr;
	ptr += sizeof (DWORD);

	//
	// Read number of resources
	//

	NumberOfResources = *(DWORD *) ptr;
	ptr += sizeof (DWORD);

	//
	// Read number of types
	//

	NumberOfTypes = *(DWORD *) ptr;
	ptr += sizeof (DWORD);

	//
	// Skip Types: (CHAR *Type;) * NumOfTypes
	// (Save position)
	//

	pTypes = ptr;

	for (UINT x = 0; x < NumberOfTypes; x++)
	{
		INT StringSize = 0;
		UINT ValueSize = 0;

		if (!DecodeInt(ptr, &StringSize, &ValueSize))
			return FALSE;
		ptr += ValueSize;

		ptr += StringSize;
	}

	//
	// Alignes position
	//

	DWORD Position = (DWORD) (((ULONG_PTR) ptr) - ((ULONG_PTR) pBaseAddress));

	DWORD Aligned = Position & 7;

	if (Aligned != 0)
	{
		ptr += (8 - Aligned);
	}

	//
	// Skip name hashes
	//

	ptr += (sizeof (DWORD) * NumberOfResources);

	//
	// Skip name positions (first save location)
	//

	pNamesOffsets = ptr;

	ptr += (sizeof (DWORD) * NumberOfResources);

	//
	// Read Data Section Offset
	//

	DWORD DataSectionOffset;

	DataSectionOffset = *(DWORD *) ptr;
	ptr += sizeof (DWORD);

	pDataSection = (BYTE *) (DataSectionOffset + ((ULONG_PTR) pBaseAddress));

	//
	// Save names position
	//

	pNames = ptr;

	return TRUE;
}

//
// Decode ints who have been encoded in 7 bits
//

BOOL CResourcesFile::DecodeInt(BYTE *pAddress, INT *Value, UINT *uSize)
{
	BYTE *ptr = pAddress;

	BYTE c;
	INT a = 0, b = 0;
	UINT x = 0;

	while (TRUE)
	{
		c = *ptr;
		ptr++;

		a |= ((c & 0x7F) << (b & 0x1F));
		b += 7;

		x++;

		if ((c & 0x80) == 0) break;
	}

	if (Value) *Value = a;
	if (uSize) *uSize = x;

	return TRUE;
}

//
// Read the name from a given resource
//

BOOL CResourcesFile::ReadName(UINT nResource, WCHAR *Str, UINT Len)
{
	DWORD NameOffset = *(DWORD *) ((nResource * sizeof (DWORD)) + 
		((ULONG_PTR) pNamesOffsets));

	if (NameOffset > (DWORD) (((ULONG_PTR) pNames) - ((ULONG_PTR) pDataSection)))
		return FALSE;

	ZeroMemory(Str, Len * sizeof (WCHAR));

	BYTE *ptr = (BYTE *) (NameOffset + ((ULONG_PTR) pNames));

	INT NameSize = 0;
	UINT ValueSize = 0;

	if (!DecodeInt(ptr, &NameSize, &ValueSize))
		return FALSE;
	ptr += ValueSize;

	memcpy(Str, ptr, NameSize);

	return TRUE;
}

//
// Collect Resource Info
//

BOOL CResourcesFile::GetResourceInfo(UINT nResource, WCHAR *Str, UINT Len,
									 DWORD *Offset, INT *TypeIndex)
{
	//
	// Read name
	//

	DWORD NameOffset = *(DWORD *) ((nResource * sizeof (DWORD)) + 
		((ULONG_PTR) pNamesOffsets));

	if (NameOffset > (DWORD) (((ULONG_PTR) pNames) - ((ULONG_PTR) pDataSection)))
		return FALSE;

	ZeroMemory(Str, Len * sizeof (WCHAR));

	BYTE *ptr = (BYTE *) (NameOffset + ((ULONG_PTR) pNames));

	INT NameSize = 0;
	UINT ValueSize = 0;

	if (!DecodeInt(ptr, &NameSize, &ValueSize))
		return FALSE;
	ptr += ValueSize;

	memcpy(Str, ptr, NameSize);

	ptr += NameSize;

	//
	// After reading the name
	//

	DWORD DataOffset = *(DWORD *) ptr;

	BYTE *pData = (BYTE *) (DataOffset + ((ULONG_PTR) pDataSection));

	//
	// Collect info
	//

	if (Offset) *Offset = (DWORD) (((ULONG_PTR) pData) - 
		((ULONG_PTR) pBaseAddress));

	if (TypeIndex)
	{
		*TypeIndex = 0;
		ValueSize = 0;

		if (!DecodeInt(pData, TypeIndex, &ValueSize))
			return FALSE;
	}
	
	return TRUE;
}

void main()
{
	TCHAR FileName[MAX_PATH];

	_tprintf(_T("Resources File to open:\n"));
	_tscanf(_T("%s"), FileName);

	//
	// Open and read file
	//

	HANDLE hFile;
	DWORD BR;
	BYTE *BaseAddress;
	DWORD FileSize; 

	hFile = CreateFile(FileName, GENERIC_READ, FILE_SHARE_READ, 
		0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);

	if (hFile == INVALID_HANDLE_VALUE) return;

	FileSize = GetFileSize(hFile, NULL);

	BaseAddress = (BYTE *) VirtualAlloc(NULL, FileSize, 
		MEM_COMMIT, PAGE_READWRITE);

	if (!ReadFile(hFile, BaseAddress, FileSize, &BR, NULL))
	{
		VirtualFree(BaseAddress, 0, MEM_RELEASE);
		CloseHandle(hFile);
		return;
	}

	CloseHandle(hFile);

	CResourcesFile ResFile;

	if (ResFile.ProcessResourcesFile(BaseAddress, FileSize) == FALSE)
	{
		VirtualFree(BaseAddress, 0, MEM_RELEASE);
		return;
	}

	_tprintf(_T("\n\nFile: %s\n"), FileName);
	_tprintf(_T("Version: %d\n"), ResFile.Version);
	_tprintf(_T("Number of resources: %d\n"), ResFile.NumberOfResources);
	_tprintf(_T("Number of types: %d\n"), ResFile.NumberOfTypes);

	_tprintf(_T("\nList resources:\n\n"));

	WCHAR ResName[1024];

	for (UINT x = 0; x < ResFile.NumberOfResources; x++)
	{
		DWORD Offset;
		INT TypeIndex = 0;

		if (ResFile.GetResourceInfo(x, ResName, 1024, &Offset, &TypeIndex))
		{
			_tprintf(_T("Name: %S - Offset: %08X - TypeIndex: %d\n"), ResName,
				Offset, TypeIndex);
		}
	}

	VirtualFree(BaseAddress, 0, MEM_RELEASE);

	getch();
}